clear all
set more off
set matsize 10000
set maxvar 30000
set memory 20000m



*****************
*Set Parameters 
*****************
*set to data files that contains the factors
local Factors_Broad    = "../data/factors_BroadMOM (CNYadj BW36 20001_201310).xls"
local Factors_Narrow   = "../data/factors_NarrowMOM (CNYadj BW36 20001_201310).xls"

*set to data file that contains Chinese industrial production
local IP_Data = `" "../../(1) Data prep/clean data/transformed data (MOM CNYadj BW36 20001_201310).dta" "'

*set to 1 to make Stata graphs. Set to 0 if you just want to export the excel data to make graphs in excel
local MakeStataGraphs = 0




************************
*Import data
************************
*import estimated factors
foreach size in Broad Narrow{
	import excel "`Factors_`size''", firstrow sheet("Factors") clear
	drop if EA1==.
	rename A dated
	rename EA1 EA_`size'
	rename PR1 PR_`size'
	
	*convert the daily date to monthly date
	gen date = mofd(dated)
	drop dated
	format date %tm
	
	save "../data/temp_files/`size'.dta", replace
}

*import industrial production data
use `IP_Data', clear
keep date IP
save "../data/temp_files/IP_for_graph.dta", replace

*merge datasets together
local size Broad
use "../data/temp_files/`size'.dta", clear
local size Narrow
merge 1:1 date using "../data/temp_files/`size'.dta"
	*perfect match
drop _merge

merge 1:1 date using "../data/temp_files/IP_for_graph.dta"
	*only early 2000s and late 2013 onwards didn't match
keep if _merge==3
drop _merge






**********************
* Take 12-month moving average and normalize all factors
**********************
tsset date

ds date, not
foreach v in `r(varlist)'{
	
	*take the 12-month moving average
	gen `v'2 = .
	replace `v'2 = (`v' + L1.`v' + L2.`v' + L3.`v' + L4.`v' + L5.`v' + L6.`v' + L7.`v' + L8.`v' + L9.`v' + L10.`v' + L11.`v')/12
	drop `v'
	rename `v'2 `v'
	
	*normalize factors (and IP) to have mean 0 and variance 1
	sum `v'
	replace `v' = (`v'-`r(mean)')/`r(sd)'
	
}



**************************
* Graph the MAed, normalized factors
***************************
if `MakeStataGraphs'==1{
	twoway line EA_Broad EA_Narrow date, title("Figure 1a: Economic Activity Factors") subtitle("12-month moving average, normalized")
	graph export "../output/graphs/EA (MOM).png", as(png) replace

	twoway line PR_Narrow date, title("Figure 1b: Inflation Factor") subtitle("12-month moving average, normalized")
	graph export "../output/graphs/PR (MOM).png", as(png) replace
}


*make year and month variables
gen year  = year(dofm(date))
gen month = month(dofm(date))
drop date

*make daily date variable that will be convenient to use in excel
gen date = dofm(ym(year, month))
order year month date
format date %td
export excel using "../output/EA PR factor data [Figure 1].xlsx", firstrow(var) sheet("factor data") sheetreplace


